/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.event.forge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import samebutdifferent.ecologics.block.FloweringAzaleaLogBlock;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.forge.ModConfigForge;
import samebutdifferent.ecologics.registry.forge.ModPlacedFeatures;
import samebutdifferent.ecologics.util.forge.CodecUtils;

@Mod.EventBusSubscriber(modid="ecologics")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        ResourceLocation biomeName = event.getName();
        if (biomeName != null) {
            if (biomeName.equals((Object)Biomes.f_48217_.m_135782_())) {
                if (((Boolean)ModConfigForge.GENERATE_COCONUT_TREES.get()).booleanValue()) {
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)ModPlacedFeatures.TREES_BEACH.getHolder().orElseThrow());
                }
                if (((Boolean)ModConfigForge.GENERATE_SEASHELLS.get()).booleanValue()) {
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)ModPlacedFeatures.SEASHELL.getHolder().orElseThrow());
                }
            }
            if (biomeName.equals((Object)Biomes.f_48203_.m_135782_())) {
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntityTypes.CAMEL.get(), ((Integer)ModConfigForge.CAMEL_SPAWN_WEIGHT.get()).intValue(), 1, 1));
                if (((Boolean)ModConfigForge.GENERATE_PRICKLY_PEARS.get()).booleanValue()) {
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)ModPlacedFeatures.PRICKLY_PEAR.getHolder().orElseThrow());
                }
                if (((Boolean)ModConfigForge.GENERATE_DESERT_RUINS.get()).booleanValue()) {
                    builder.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, (Holder)ModPlacedFeatures.DESERT_RUIN.getHolder().orElseThrow());
                }
            }
            if (biomeName.equals((Object)Biomes.f_48212_.m_135782_()) || biomeName.equals((Object)Biomes.f_48211_.m_135782_()) || biomeName.equals((Object)Biomes.f_186761_.m_135782_())) {
                if (((Boolean)ModConfigForge.GENERATE_THIN_ICE_PATCHES.get()).booleanValue()) {
                    builder.m_204201_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, (Holder)ModPlacedFeatures.THIN_ICE_PATCH.getHolder().orElseThrow());
                }
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntityTypes.PENGUIN.get(), ((Integer)ModConfigForge.PENGUIN_SPAWN_WEIGHT.get()).intValue(), 4, 7));
            }
            if (biomeName.equals((Object)Biomes.f_151785_.m_135782_())) {
                if (((Boolean)ModConfigForge.GENERATE_SURFACE_MOSS.get()).booleanValue()) {
                    builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).removeIf(placedFeatureSupplier -> CodecUtils.serializeAndCompareFeature((PlacedFeature)placedFeatureSupplier.m_203334_(), (PlacedFeature)CavePlacements.f_195250_.m_203334_()));
                    builder.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)ModPlacedFeatures.SURFACE_MOSS_PATCH.getHolder().orElseThrow());
                }
                if (((Boolean)ModConfigForge.REPLACE_AZALEA_TREE.get()).booleanValue()) {
                    builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).removeIf(placedFeatureSupplier -> CodecUtils.serializeAndCompareFeature((PlacedFeature)placedFeatureSupplier.m_203334_(), (PlacedFeature)CavePlacements.f_195244_.m_203334_()));
                    builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add((Holder)ModPlacedFeatures.ROOTED_AZALEA_TREE.getHolder().orElseThrow());
                }
            }
            if (biomeName.equals((Object)Biomes.f_48202_.m_135782_())) {
                if (((Boolean)ModConfigForge.REMOVE_PLAINS_OAK_TREES.get()).booleanValue()) {
                    builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).removeIf(placedFeatureSupplier -> CodecUtils.serializeAndCompareFeature((PlacedFeature)placedFeatureSupplier.m_203334_(), (PlacedFeature)VegetationPlacements.f_195421_.m_203334_()));
                }
                if (((Boolean)ModConfigForge.GENERATE_WALNUT_TREES.get()).booleanValue()) {
                    builder.getFeatures(GenerationStep.Decoration.VEGETAL_DECORATION).add((Holder)ModPlacedFeatures.TREES_WALNUT.getHolder().orElseThrow());
                }
                event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntityTypes.SQUIRREL.get(), ((Integer)ModConfigForge.SQUIRREL_SPAWN_WEIGHT.get()).intValue(), 2, 3));
            }
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        CodecUtils.clearCache();
    }

    @SubscribeEvent
    public static void onCropGrow(BlockEvent.CropGrowEvent.Post event) {
        BlockPos pos = event.getPos();
        LevelAccessor level = event.getWorld();
        BlockState state = event.getState();
        if (state.m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50128_) && level.m_46859_(pos.m_6630_(2)) && (double)level.m_5822_().nextFloat() <= (Double)ModConfigForge.PRICKLY_PEAR_GROWTH_CHANCE.get()) {
            level.m_7731_(pos.m_6630_(2), ModBlocks.PRICKLY_PEAR.get().m_49966_(), 2);
            level.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        InteractionHand hand = event.getHand();
        if (state.m_60713_((Block)ModBlocks.POT.get()) && player.m_6047_()) {
            if (player.m_21205_().m_41720_() instanceof PickaxeItem && hand.equals((Object)InteractionHand.MAIN_HAND)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.MAIN_HAND);
                player.m_21205_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.MAIN_HAND));
            }
            if (player.m_21206_().m_41720_() instanceof PickaxeItem && !(player.m_21205_().m_41720_() instanceof PickaxeItem) && hand.equals((Object)InteractionHand.OFF_HAND)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.OFF_HAND);
                player.m_21206_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.OFF_HAND));
            }
        }
        if (!event.getWorld().f_46443_) {
            Direction direction;
            ItemStack stack = event.getItemStack();
            Direction direction2 = direction = event.getHitVec().m_82434_().m_122434_() == Direction.Axis.Y ? event.getHitVec().m_82434_().m_122424_() : event.getHitVec().m_82434_();
            if (stack.m_150930_(Items.f_42574_)) {
                if (state.m_60713_(Blocks.f_152542_)) {
                    FloweringAzaleaLogBlock.shearAzalea(level, player, pos, stack, hand, direction, Blocks.f_152541_.m_49966_());
                    player.m_21011_(hand, true);
                }
                if (state.m_60713_(Blocks.f_152471_)) {
                    FloweringAzaleaLogBlock.shearAzalea(level, player, pos, stack, hand, direction, Blocks.f_152470_.m_49966_());
                    player.m_21011_(hand, true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            ResourceLocation remapped;
            if (mapping.key.equals((Object)new ResourceLocation("ecologics", "coconut_husk"))) {
                remapped = new ResourceLocation("ecologics", "coconut_seedling");
                if (ForgeRegistries.BLOCKS.containsKey(remapped)) {
                    mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(remapped)));
                } else {
                    mapping.warn();
                }
            }
            if (!mapping.key.equals((Object)new ResourceLocation("ecologics", "potted_coconut_husk"))) continue;
            remapped = new ResourceLocation("ecologics", "potted_coconut_seedling");
            if (ForgeRegistries.BLOCKS.containsKey(remapped)) {
                mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(remapped)));
                continue;
            }
            mapping.warn();
        }
    }
}

